<?php

class SzkolenieController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','view','reportedExams',
					'ignoreReportedExam','resetReportedExam','acceptReportedExam',
					'addTrainingAnswer','generateQuestions',
					'exam','addQuestion','updateQuestion','deleteQuestion'),
				'roles'=>array('admin')
			),
			array('allow',
				'actions'=>array('reportedExams',
					'ignoreReportedExam','resetReportedExam','acceptReportedExam',
					'addTrainingAnswer'),
				'roles'=>array('schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Szkolenie;

		if(isset($_POST['Szkolenie']))
		{
			$model->attributes = $_POST['Szkolenie'];

			if($model->save(false))
				$this->redirect(array('update', 'id'=>$model->id));
		}

		$this->render('create', array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		if(isset($_POST['Szkolenie']))
		{
			$model->attributes = $_POST['Szkolenie'];

			if($model->save(false))
				$this->redirect(array('view', 'id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	public function actionExam($id)
	{
		$model = Szkolenie::model()->findByPk($id);

		$this->render('exam',array(
			'model'=>$model,
		));
	}

	public function actionAddQuestion($id)
	{
		$model = new SzkoleniePytaniaEgzamin;
		$model->szkolenie = Szkolenie::model()->with(array('pytania','pytania.odpowiedzi'))->findByPk($id);
		$model->idSzkolenia = $id;
		$answers = array();

		if(isset($_POST['SzkoleniePytaniaEgzamin']))
		{
			$model->attributes = $_POST['SzkoleniePytaniaEgzamin'];

			$model->image=CUploadedFile::getInstance($model,'image');

			//saving image in temporary folder
			if(!empty($model->image))
			{
				if (!file_exists('uploads/temp/'.$model->tempFolderName.'/'))
					mkdir('uploads/temp/'.$model->tempFolderName.'/', 0777, true);

				$model->image->saveAs('uploads/temp/'.$model->tempFolderName.'/'.$model->image->name);
				$model->tempImageName = $model->image->name;
			}

			$modelsValid = true;

			//validating answers
			if(isset($_POST['SzkolenieOdpowiedziEgzamin']))
			{
				foreach($_POST['SzkolenieOdpowiedziEgzamin'] as $answer)
				{
					$answerModel = new SzkolenieOdpowiedziEgzamin;
					$answerModel->attributes = $answer;
					$answers[] = $answerModel;
					if(!$answerModel->validate())
						$modelsValid = false;
				}
			}

			if($model->validate() && $modelsValid)
			{
				$model->save(false);

				//image exists in temp dir
				if(!empty($model->tempImageName))
					$model->urlObrazka = 'uploads/trainings/'.$model->id.'/'.$model->tempImageName;

				$model->save(false);

				//dodanie tworzonego pytania do zlecen
				$zlecenie = new Zlecenie;
				$zlecenie->idDziedziny = $model->szkolenie->idDziedzina;
				$zlecenie->poziom = $model->szkolenie->poziom;
				$zlecenie->czyEgzamin = 1;
				$zlecenie->czyPrzetarg = 0;
				$zlecenie->tresc = $model->tresc;
				$zlecenie->urlObrazka = $model->urlObrazka;
				$zlecenie->kara = $zlecenie->getKaraNum();
				$zlecenie->save(false);

				$szkolenieZlecenie = new SzkolenieZlecenie;
				$szkolenieZlecenie->idSzkoleniePytaniaEgzamin = $model->id;
				$szkolenieZlecenie->idZlecenie = $zlecenie->id;
				$szkolenieZlecenie->save(false);

				//saving answers models
				foreach($answers as $answer)
				{
					$answer->idPytania = $model->id;
					$answer->save(false);

					//zapisanie odpowiedzi do zlecenia
					$zlecenieOdp = new ZlecenieOdpowiedz;
					$zlecenieOdp->idZlecenia = $zlecenie->id;
					$zlecenieOdp->odpowiedz = $answer->tresc;
					$zlecenieOdp->save(false);
				}

				//move a photo from the temp directory to a proper one
				if(!empty($model->tempImageName) && !empty($model->tempFolderName))
				{
					if (!file_exists('uploads/trainings/'.$model->id))
						mkdir('uploads/trainings/'.$model->id, 0777, true);

					copy('uploads/temp/'.$model->tempFolderName.'/'.$model->tempImageName, 'uploads/trainings/'.$model->id.'/'.$model->tempImageName);
					unlink('uploads/temp/'.$model->tempFolderName.'/'.$model->tempImageName);
					//removing temp dir and its files
					foreach(scandir('uploads/temp/'.$model->tempFolderName) as $file)
							if(is_file('uploads/temp/'.$model->tempFolderName.'/'.$file))
									unlink('uploads/temp/'.$model->tempFolderName.'/'.$file);
					rmdir('uploads/temp/'.$model->tempFolderName);
				}

				$this->redirect(array('/administration/szkolenie/exam', 'id'=>$id));
			}
		}
		else //at the start - generation unique temp folder name
		{
			$model->tempFolderName = uniqid();
			while(file_exists('uploads/temp/'.$model->tempFolderName))
			{
				$model->tempFolderName = uniqid();
			}
			mkdir('uploads/temp/'.$model->tempFolderName, 0777, true);
		}

		$this->render('addQuestion',array(
			'model'=>$model,
			'answers'=>$answers
		));
	}

	public function actionUpdateQuestion($id)
	{
		$model = SzkoleniePytaniaEgzamin::model()->findByPk($id);
		$answers = $model->odpowiedzi;

		$szkolenieZlecenie = SzkolenieZlecenie::model()->findByAttributes(array('idSzkoleniePytaniaEgzamin' => $id));

		if(isset($_POST['SzkoleniePytaniaEgzamin']))
		{
			$model->image=CUploadedFile::getInstance($model,'image');

			if(!empty($model->image))
			{
				if(!file_exists('uploads/trainings/'.$model->id))
					mkdir('uploads/trainings/'.$model->id, 0777, true);

				//cleaning image dir
				foreach(scandir('uploads/trainings/'.$model->id) as $file)
						if(is_file('uploads/trainings/'.$model->id.'/'.$file))
								unlink('uploads/trainings/'.$model->id.'/'.$file);

				$model->urlObrazka = 'uploads/trainings/'.$model->id.'/'.$model->image->name;
				$model->image->saveAs('uploads/trainings/'.$model->id.'/'.$model->image->name);

				$model->save(false);
			}

			unset($_POST['SzkoleniePytaniaEgzamin']['urlObrazka']);
			$model->attributes = $_POST['SzkoleniePytaniaEgzamin'];

			$modelsValid = true;

			//validating answers
			if(isset($_POST['SzkolenieOdpowiedziEgzamin']))
			{
				foreach($_POST['SzkolenieOdpowiedziEgzamin'] as $answer)
				{
					$answerModel = new SzkolenieOdpowiedziEgzamin;
					$answerModel->attributes = $answer;
					$answers[] = $answerModel;
					if(!$answerModel->validate())
						$modelsValid = false;
				}
			}

			if($model->validate() && $modelsValid)
			{
				SzkolenieOdpowiedziEgzamin::model()->deleteAll('"idPytania"='.$id);

				$model->save(false);

				if($szkolenieZlecenie !== null)
				{
					$zlecenie = $szkolenieZlecenie->zlecenie;
					$zlecenie->tresc = $model->tresc;
					$zlecenie->save(false);

					ZlecenieOdpowiedz::model()->deleteAll('"idZlecenia"='.$zlecenie->id);
				}

				//saving answers models
				foreach($answers as $answer)
				{
					$answer->idPytania = $model->id;
					$answer->save(false);

					if($szkolenieZlecenie !== null)
					{
						//zapisanie odpowiedzi do zlecenia
						$zlecenieOdp = new ZlecenieOdpowiedz;
						$zlecenieOdp->idZlecenia = $zlecenie->id;
						$zlecenieOdp->odpowiedz = $answer->tresc;
						$zlecenieOdp->save(false);
					}
				}

				$this->redirect(array('/administration/szkolenie/exam', 'id'=>$model->idSzkolenia));
			}
		}

		$this->render('updateQuestion',array(
			'model'=>$model,
			'answers'=>$answers
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDeleteQuestion($id)
	{
		try
		{
			$model = SzkoleniePytaniaEgzamin::model()->findByPk($id);
			$trainingId = $model->idSzkolenia;

			//usuniecie powiazania ze zleceniem (o ile istnieje)
			$szkolenieZlecenie = SzkolenieZlecenie::model()->findByAttributes(array('idSzkoleniePytaniaEgzamin'=>$model->id));
			if($szkolenieZlecenie !== null)
				$szkolenieZlecenie->delete();

			$model->delete();

			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('/administration/szkolenie/exam','id'=>$trainingId));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$this->loadModel($id)->delete();

			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	public function actionReportedExams()
	{
		$condition = '"zgloszone" IS NOT NULL';

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese))
			$condition = '"zgloszone" IS NOT NULL AND "idFirmy" IN ('.implode(',',Yii::app()->user->getState('companies')).')';
		elseif(Yii::app()->user->role == 'schoolAdmin' && empty($companiese))
			$condition = null;
		
		if($condition !== null)
			$zgloszone = SzkolenieFirmy::model()->with('idFirmy0', 'pytaniaEgzaminacyjne')->findAll($condition);
		else
			$zgloszone = array();

//		$zgloszone = SzkolenieFirmy::model()->findAll('"zgloszone" IS NOT NULL');

		$this->render('reportedExams', array(
			'szkolenia' => $zgloszone,
		));
	}

	public function actionIgnoreReportedExam($id)
	{
		$szkolenie = SzkolenieFirmy::model()->findByPk($id);

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($szkolenie->idFirmy, Yii::app()->user->getState('companies')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$emails = array();
		foreach($szkolenie->idFirmy0->activeUsers as $user)
			$emails[] = $user->email;

		$szkolenie->zgloszone = null;
		$szkolenie->save(false);

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie odrzucono";
		$message = 'Witaj, zgłoszono do nas następujący egzamin: '. $szkolenie->idSzkolenia0->nazwa . ' z dziedziny ' . $szkolenie->idSzkolenia0->dziedzina->nazwa;
		$message .= '. Decyzja: odwołanie odrzucono.';
		$to = implode(", ",$emails);
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('reportedExams'));
	}

	public function actionResetReportedExam($id)
	{
		$szkolenie = SzkolenieFirmy::model()->findByPk($id);

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($szkolenie->idFirmy, Yii::app()->user->getState('companies')) )
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$emails = array();
		foreach($szkolenie->idFirmy0->activeUsers as $user)
			$emails[] = $user->email;

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			//usuniecie faktury i oplaty przypisanej do szkolenia
			$zwrot = 0;
			$faktura = Faktury::model()->findByPk($szkolenie->idFaktury);
			if(!empty($faktura))
			{
				//usuniecie oplat
				$nrFaktury = $faktura->nrFaktury;
				$criteria = new CDbCriteria(array(
					'condition' => '"tytul" LIKE :nrFaktury',
					'params' => array(':nrFaktury' => "%$nrFaktury%")
				));
				$oplaty = Oplaty::model()->deleteAll($criteria);

				$zwrot = $faktura->cenaNetto * (1 + str_replace(",", ".", $faktura->stawkaVat));
				$faktura->delete();
			}

//			$szkolenie->idFaktury = null;
//			$szkolenie->czySukces = 0;
//			$szkolenie->dataRozpoczecia = null;
//			$szkolenie->dataZakonczenia = null;
//			$szkolenie->zgloszone = null;

			//usuniecie danych z tabeli SzkolenieFirmyOdp
			SzkolenieFirmyOdp::model()->deleteAll(array(
				'condition' => '"idSzkolenieFirmy" = :idSzkolenieFirmy',
				'params' => array(':idSzkolenieFirmy'=>$szkolenie->id),
			));

			$szkolenie->idFirmy0->stanKonta = (float)$szkolenie->idFirmy0->stanKonta + (float)$zwrot;
			$szkolenie->idFirmy0->save(false);

//			$szkolenie->save(false);
			$szkolenie->delete();

			$transaction->commit();
		}
		catch(Exception $e)
		{
			$transaction->rollback();
		}

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie odrzucono";
		$message = 'Witaj, zgłoszono do nas następujący egzamin: '. $szkolenie->idSzkolenia0->nazwa . ' z dziedziny ' . $szkolenie->idSzkolenia0->dziedzina->nazwa;
		$message .= '. Decyzja: odwołanie zaakceptowano. Koszty przeprowadzenia egzaminu zostały zwrócone. Twoja Firma może ponownie wykupić wybrany egzamin.';
		$to = implode(", ",$emails);
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('reportedExams'));
	}

	public function actionAcceptReportedExam($id)
	{
		$szkolenie = SzkolenieFirmy::model()->findByPk($id);

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($szkolenie->idFirmy, Yii::app()->user->getState('companies')) )
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$firma = $szkolenie->idFirmy0;

		$emails = array();
		foreach($szkolenie->idFirmy0->activeUsers as $user)
			$emails[] = $user->email;

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			$szkolenie->czySukces = 1;
			$szkolenie->zgloszone = null;

			$points = array(
				Zlecenie::LEVEL_EASY => ParametryGry::getFloat('PUNKTY_EGZAMIN_LATWY', 10),
				Zlecenie::LEVEL_HARD => ParametryGry::getFloat('PUNKTY_EGZAMIN_SREDNI', 50),
				Zlecenie::LEVEL_VERY_HARD => ParametryGry::getFloat('PUNKTY_EGZAMIN_TRUDNY', 100)
			);

			//punkty do szkolenia pracownika (z SzkolenieFirmy->accept)
			$firma->transferPointsWithWorkers($szkolenie->idSzkolenia0->idDziedzina, $points[$szkolenie->idSzkolenia0->poziom]);
			foreach ($firma->activeWorkers as $worker)
			{
				$cert = new SzkoleniePracownika;
				$cert->dataSzkolenia = $szkolenie->dataZakonczenia;
				$cert->idPracownika = $worker->id;
				$cert->idSzkolenia = $szkolenie->idSzkolenia;
				$cert->save(false);
			}

			$szkolenie->save(false);

			$transaction->commit();
		}
		catch(Exception $e)
		{
			$transaction->rollback();
		}

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie odrzucono";
		$message = 'Witaj, zgłoszono do nas następujący egzamin: '. $szkolenie->idSzkolenia0->nazwa . ' z dziedziny ' . $szkolenie->idSzkolenia0->dziedzina->nazwa;
		$message .= '. Decyzja: odwołanie zaakceptowano. Ezgamin został uznany jako zaliczony.';
		$to = implode(", ",$emails);
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('reportedExams'));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Szkolenie('search');
		$model->unsetAttributes();

		if(isset($_GET['Szkolenie']))
			$model->attributes = $_GET['Szkolenie'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	public function actionAddTrainingAnswer()
	{
		if(isset($_POST['szkolenieId'], $_POST['pytanieId']) && !empty($_POST['szkolenieId']) && !empty($_POST['pytanieId']))
		{
			$szkolenieId = filter_input(INPUT_POST, 'szkolenieId', FILTER_VALIDATE_INT);
			$pytanieId = filter_input(INPUT_POST, 'pytanieId', FILTER_VALIDATE_INT);
			$szkolenieOdp = SzkolenieOdpowiedziFirmy::model()->findByPk(array('idSzkolenieFirmy'=>$szkolenieId, 'idPytania'=>$pytanieId));

			if($szkolenieOdp !== null)
			{
				$odp = new SzkolenieOdpowiedziEgzamin;
				$odp->idPytania = $pytanieId;
				$odp->tresc = $szkolenieOdp->wartosc;
				$odp->save(false);

				echo $szkolenieOdp->wartosc;
			}
			else
				echo 'ERROR';
		}
	}

	public function actionGenerateQuestions($id)
	{
		$szkolenie = Szkolenie::model()->findByPk($id);

		$countQuestions = count($szkolenie->pytania);
//		CVarDumper::dump($countQuestions, 10, true);
//		die();

		$ILOSC_ZLECEN_W_SZKOLENIU = 3; // na razie tutaj

		if($countQuestions >= $ILOSC_ZLECEN_W_SZKOLENIU) //ILOSC_ZLECEN_W_SZKOLENIU
			throw new  CHttpException(404, 'Szkolenie posiada wystarczającą liczbę pytań egzaminacyjnych.');

		$numberOfGeneratedQuestions = $ILOSC_ZLECEN_W_SZKOLENIU - $countQuestions;

		//wylosuj pytania
		if ($szkolenie->czyEgzamin)
		{
			$PYTANIA = Zlecenie::model()->findAllBySql('
				SELECT * FROM (
					select * from "Zlecenie" "z"
					where "z"."idDziedziny" = :idDziedziny AND "z"."poziom" = :poziom AND
						"z"."czyEgzamin" > 0 AND ("z"."wylaczone" is null or "z"."wylaczone" != 1) /*AND LOWER("z"."kategoria") = LOWER(:nazwa)*/
					ORDER BY dbms_random.value
				)
				WHERE rownum <= :max
			', array(
//				':max' => (int)ParametryGry::getValue('EGZAMIN_ILOSC_PYTAN', 5),
				':max' => $numberOfGeneratedQuestions,
				':idDziedziny' => $szkolenie->idDziedzina,
				':poziom' => $szkolenie->poziom
				//':nazwa' => $SZKOLENIE->nazwa
			));
		}

		//zapisanie pytan
		foreach($PYTANIA as $PYTANIE)
		{
			$pytEx = new SzkoleniePytaniaEgzamin;
			$pytEx->idSzkolenia = $szkolenie->id;
			$pytEx->tresc = $PYTANIE->tresc;
			$pytEx->save(false);

			$odpowiedzi = $PYTANIE->odpowiedziZlecenia;

			foreach($odpowiedzi as $odpowiedz)
			{
				$odpEx = new SzkolenieOdpowiedziEgzamin;
				$odpEx->idPytania = $pytEx->id;
				$odpEx->tresc = $odpowiedz->odpowiedz;
				$odpEx->save(false);
			}
		}

		$this->redirect(array('exam', 'id'=>$id));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Szkolenie::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		return $model;
	}
}
